<?php

namespace App\Http\Controllers;

use App\Models\AgeingAnalysis;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class AgeingAnalysisController extends Controller
{
    public function index()
    {
        $ageingAnalyses = AgeingAnalysis::all();
        return view('modules.edit.add-age-analysis-new', compact('ageingAnalyses'));
    }

    public function create()
    {
        return view('modules.edit.add-age-analysis-new');
    }

    public function store(Request $request)
    {
        $request->validate([
            'age_code' => 'required|string|max:50|unique:supplier_ageing_analysis,age_code',
            'description' => 'required|string|max:191',
            'group_type' => 'required|in:monthly,daily,custom',
            'interval_type' => 'required|in:statement_date,invoice_date',
            'interval_days' => 'required|integer|min:1',
            'custom_ages' => 'nullable|array',
            'custom_intervals' => 'nullable|array',
        ]);

        $data = $request->only(['age_code', 'description', 'group_type', 'interval_type', 'interval_days']);
        $data['custom_ages'] = json_encode($request->custom_ages ?? []);
        $data['custom_intervals'] = json_encode($request->custom_intervals ?? []);

        AgeingAnalysis::create($data);

        Session::flash('success', 'Ageing Analysis configuration created successfully.');
        return redirect()->route('modules.edit.add-age-analysis-new');
    }

    public function show($id)
    {
        $ageingAnalysis = AgeingAnalysis::findOrFail($id);
        return view('modules.edit.edit-age-analysis', compact('ageingAnalysis'));
    }

    public function edit($id)
    {
        $ageingAnalysis = AgeingAnalysis::findOrFail($id);
        return view('modules.edit.edit-age-analysis', compact('ageingAnalysis'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'age_code' => 'required|string|max:255|unique:ageing_analyses,age_code,' . $id,
            'description' => 'required|string|max:255',
            'ageing_group' => 'required|in:monthly,daily,custom',
            'interval_type' => 'required|in:invoiceDate,statementDate',
            'interval' => 'required|in:30,7,customInterval',
            'custom_age_groups' => 'nullable|json',
            'custom_intervals' => 'nullable|json',
        ]);

        $ageingAnalysis = AgeingAnalysis::findOrFail($id);
        $ageingAnalysis->update($request->all());

        Session::flash('success', 'Ageing Analysis configuration updated successfully.');
        return redirect()->route('modules.edit.add-age-analysis-new');
    }

    public function destroy($id)
    {
        $ageingAnalysis = AgeingAnalysis::findOrFail($id);
        $ageingAnalysis->delete();

        Session::flash('success', 'Ageing Analysis configuration deleted successfully.');
        return redirect()->route('modules.edit.add-age-analysis-new');
    }
}
