<?php

namespace App\Http\Controllers;

use App\Models\CaseCategory;
use Illuminate\Http\Request;

class CaseCategoryController extends Controller
{
    public function caseCategory()
    {
        return view('modules.edit.case-category');
    }

    public function caseCategoryList()
    {
        $caseCategories = CaseCategory::all();
        return view('modules.edit.case-category-list', compact('caseCategories'));
    }

    public function caseCategoryAdd()
    {
        return view('modules.edit.case-category-add');
    }

    public function index()
    {
        $caseCategories = CaseCategory::all();
        return view('modules.edit.case-category-list', compact('caseCategories'));
    }

    public function create()
    {
        return view('modules.edit.case-category-add');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'category_code' => 'required|string|max:255|unique:case_categories,category_code',
            'category_description' => 'required|string|max:255',
        ]);

        CaseCategory::create($validated);

        return redirect()->route('modules.edit.case-categories.list')->with('success', 'Case Category created successfully.');
    }

    public function show($category_code)
    {
        $caseCategory = CaseCategory::findOrFail($category_code);
        return view('modules.edit.case-category-show', compact('caseCategory'));
    }

    public function edit($category_code)
    {
        $caseCategory = CaseCategory::findOrFail($category_code);
        return view('modules.edit.edit-case-category', compact('caseCategory'));
    }

    public function update(Request $request, $category_code)
    {
        $caseCategory = CaseCategory::findOrFail($category_code);

        $validated = $request->validate([
            'category_code' => 'required|string|max:255|unique:case_categories,category_code,' . $category_code . ',category_code',
            'category_description' => 'required|string|max:255',
        ]);

        $caseCategory->update($validated);

        return redirect()->route('modules.edit.case-categories.list')->with('success', 'Case Category updated successfully.');
    }

    public function destroy($category_code)
    {
        $caseCategory = CaseCategory::findOrFail($category_code);
        $caseCategory->delete();

        return redirect()->route('modules.edit.case-categories.list')->with('success', 'Case Category deleted successfully.');
    }
}
