<?php

namespace App\Http\Controllers;

use App\Models\CaseOutcome;
use Illuminate\Http\Request;

class CaseOutcomeController extends Controller
{
    public function index()
    {
        $caseOutcomes = CaseOutcome::orderBy('name')->get();
        return view('modules.edit.case-outcomes-list', compact('caseOutcomes'));
    }

    public function create()
    {
        return view('modules.edit.add-case-outcomes');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:case_outcomes,code',
            'name' => 'required|string|max:50',
            'description' => 'nullable|string',
        ]);

        CaseOutcome::create($validated);

        return redirect()->route('modules.edit.case-outcomes.list')->with('success', 'Case outcome created successfully.');
    }

    public function show($id)
    {
        $caseOutcome = CaseOutcome::findOrFail($id);
        return view('modules.edit.case-outcomes-show', compact('caseOutcome'));
    }

    public function edit($id)
    {
        $caseOutcome = CaseOutcome::findOrFail($id);
        return view('modules.edit.edit-case-outcomes', compact('caseOutcome'));
    }

    public function update(Request $request, $id)
    {
        $caseOutcome = CaseOutcome::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:case_outcomes,code,' . $caseOutcome->id,
            'name' => 'required|string|max:50',
            'description' => 'nullable|string',
        ]);

        $caseOutcome->update($validated);

        return redirect()->route('modules.edit.case-outcomes.list')->with('success', 'Case outcome updated successfully.');
    }

    public function destroy($id)
    {
        $caseOutcome = CaseOutcome::findOrFail($id);
        $caseOutcome->delete();

        return redirect()->route('modules.edit.case-outcomes.list')->with('success', 'Case outcome deleted successfully.');
    }
}
