<?php

namespace App\Http\Controllers;

use App\Models\CasePriority;
use Illuminate\Http\Request;

class CasePriorityController extends Controller
{
    public function casePriority()
    {
        return view('modules.edit.case-priorities');
    }

    public function casePriorityList()
    {
        $casePriorities = CasePriority::all();
        return view('modules.edit.case-priorities-list', compact('casePriorities'));
    }

    public function casePriorityAdd()
    {
        return view('modules.edit.case-priorities-add');
    }

    public function index()
    {
        $casePriorities = CasePriority::all();
        return view('modules.edit.case-priorities-list', compact('casePriorities'));
    }

    public function create()
    {
        return view('modules.edit.case-priorities-add');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'priority_name' => 'required|string|max:255|unique:case_priorities,priority_name',
            'description' => 'nullable|string',
            'severity_rank' => 'required|integer|min:1|max:6',
        ]);

        CasePriority::create($validated);

        return redirect()->route('modules.edit.case-priorities.list')->with('success', 'Case Priority created successfully.');
    }

    public function show($priority_id)
    {
        $casePriority = CasePriority::findOrFail($priority_id);
        return view('modules.edit.case-priorities-show', compact('casePriority'));
    }

    public function edit($priority_id)
    {
        $casePriority = CasePriority::findOrFail($priority_id);
        return view('modules.edit.edit-case-priorities', compact('casePriority'));
    }

    public function update(Request $request, $priority_id)
    {
        $casePriority = CasePriority::findOrFail($priority_id);

        $validated = $request->validate([
            'priority_name' => 'required|string|max:255|unique:case_priorities,priority_name,' . $priority_id . ',priority_id',
            'description' => 'nullable|string',
            'severity_rank' => 'required|integer|min:1|max:6',
        ]);

        $casePriority->update($validated);

        return redirect()->route('modules.edit.case-priorities.list')->with('success', 'Case Priority updated successfully.');
    }

    public function destroy($priority_id)
    {
        $casePriority = CasePriority::findOrFail($priority_id);
        $casePriority->delete();

        return redirect()->route('modules.edit.case-priorities.list')->with('success', 'Case Priority deleted successfully.');
    }
}
