<?php

namespace App\Http\Controllers;

use App\Models\CaseStatus;
use Illuminate\Http\Request;

class CaseStatusController extends Controller
{
    public function index()
    {
        $caseStatuses = CaseStatus::active()->ordered()->get();
        return view('modules.edit.case-status-list', compact('caseStatuses'));
    }

    public function create()
    {
        return view('modules.edit.add-case-status');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'status_code' => 'required|string|max:20|unique:case_statuses,status_code',
            'status_name' => 'required|string|max:255',
            'status_description' => 'nullable|string',
            'color_code' => 'required|string|max:7|regex:/^#[0-9A-Fa-f]{6}$/',
            'is_active' => 'boolean',
            'sort_order' => 'integer|min:0',
        ]);

        $validated['is_active'] = $request->has('is_active');
        $validated['sort_order'] = $request->input('sort_order', 0);

        CaseStatus::create($validated);

        return redirect()->route('case-statuses.index')->with('success', 'Case status created successfully.');
    }

    public function show($id)
    {
        $caseStatus = CaseStatus::findOrFail($id);
        return view('modules.edit.case-status-show', compact('caseStatus'));
    }

    public function edit($id)
    {
        $caseStatus = CaseStatus::findOrFail($id);
        return view('modules.edit.edit-case-status', compact('caseStatus'));
    }

    public function update(Request $request, $id)
    {
        $caseStatus = CaseStatus::findOrFail($id);

        $validated = $request->validate([
            'status_code' => 'required|string|max:20|unique:case_statuses,status_code,' . $caseStatus->id,
            'status_name' => 'required|string|max:255',
            'status_description' => 'nullable|string',
            'color_code' => 'required|string|max:7|regex:/^#[0-9A-Fa-f]{6}$/',
            'is_active' => 'boolean',
            'sort_order' => 'integer|min:0',
        ]);

        $validated['is_active'] = $request->has('is_active');
        $validated['sort_order'] = $request->input('sort_order', 0);

        $caseStatus->update($validated);

        return redirect()->route('case-statuses.index')->with('success', 'Case status updated successfully.');
    }

    public function destroy($id)
    {
        $caseStatus = CaseStatus::findOrFail($id);
        $caseStatus->delete();

        return redirect()->route('case-statuses.index')->with('success', 'Case status deleted successfully.');
    }
}
