<?php

namespace App\Http\Controllers;

use App\Models\CaseType;
use Illuminate\Http\Request;

class CaseTypeController extends Controller
{
    public function caseType()
    {
        return view('modules.edit.case-type');
    }

    public function caseTypeList()
    {
        $caseTypes = CaseType::all();
        return view('modules.edit.case-type-list', compact('caseTypes'));
    }

    public function caseTypeAdd()
    {
        return view('modules.edit.case-type-add');
    }

    public function index()
    {
        $caseTypes = CaseType::all();
        return view('modules.edit.case-type', compact('caseTypes'));
    }

    public function list()
    {
        $caseTypes = CaseType::all();
        return view('modules.edit.case-type-list', compact('caseTypes'));
    }

    public function create()
    {
        return view('modules.edit.case-type');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'type_name' => 'required|string|max:255|unique:case_types,type_name',
            'type_description' => 'nullable|string',
        ]);

        CaseType::create($validated);

        return redirect()->route('modules.edit.case-types.list')->with('success', 'Case Type created successfully.');
    }

    public function show($id)
    {
        $caseType = CaseType::findOrFail($id);
        return view('modules.edit.case-type-show', compact('caseType'));
    }

    public function edit($id)
    {
        $caseType = CaseType::findOrFail($id);
        return view('modules.edit.edit-case-type', compact('caseType'));
    }

    public function update(Request $request, $id)
    {
        $caseType = CaseType::findOrFail($id);

        $validated = $request->validate([
            'type_name' => 'required|string|max:255|unique:case_types,type_name,' . $caseType->type_id . ',type_id',
            'type_description' => 'nullable|string',
        ]);

        $caseType->update($validated);

        return redirect()->route('modules.edit.case-types.list')->with('success', 'Case Type updated successfully.');
    }

    public function destroy($id)
    {
        $caseType = CaseType::findOrFail($id);
        $caseType->delete();

        return redirect()->route('modules.edit.case-types')->with('success', 'Case Type deleted successfully.');
    }
}
