<?php

namespace App\Http\Controllers;

use App\Models\MainAccount;
use Illuminate\Http\Request;

class CashbookController extends Controller
{
    public function cashBook()
    {
        $mainAccounts = MainAccount::with('accountType')->get();
        $currencies = \App\Models\Currency::all();
        $cashbookEntries = \App\Models\CashbookEntry::with(['cashbook', 'account', 'currency'])->get();

        return view('modules.processing.cash-book', compact('mainAccounts', 'currencies', 'cashbookEntries'));
    }

    public function storeCashbookEntry(Request $request)
    {
        $validated = $request->validate([
            'cashbook_id' => 'required|integer|exists:main_accounts,id',
            'entry_date' => 'required|date',
            'module' => 'required|in:AR,AP,GL,CB',
            'account_id' => 'required|integer|exists:main_accounts,id',
            'reference' => 'nullable|string|max:255',
            'description' => 'required|string',
            'tr_code' => 'required|in:DR,CR',
            'currency_id' => 'required|integer|exists:currencies,id',
            'amount' => 'required|numeric|min:0',
        ]);

        \App\Models\CashbookEntry::create($validated);

        return redirect()->back()->with('success', 'Cashbook entry added successfully.');
    }

    public function editCashbookEntry($id)
    {
        $entry = \App\Models\CashbookEntry::with(['cashbook', 'account', 'currency'])->findOrFail($id);
        $mainAccounts = MainAccount::with('accountType')->get();
        $currencies = \App\Models\Currency::all();

        return view('modules.processing.cash-book', compact('entry', 'mainAccounts', 'currencies'));
    }

    public function updateCashbookEntry(Request $request, $id)
    {
        $entry = \App\Models\CashbookEntry::findOrFail($id);

        $validated = $request->validate([
            'cashbook_id' => 'required|integer|exists:main_accounts,id',
            'entry_date' => 'required|date',
            'module' => 'required|in:AR,AP,GL,CB',
            'account_id' => 'required|integer|exists:main_accounts,id',
            'reference' => 'nullable|string|max:255',
            'description' => 'required|string',
            'tr_code' => 'required|in:DR,CR',
            'currency_id' => 'required|integer|exists:currencies,id',
            'amount' => 'required|numeric|min:0',
        ]);

        $entry->update($validated);

        return redirect()->back()->with('success', 'Cashbook entry updated successfully.');
    }

    public function deleteCashbookEntry($id)
    {
        $entry = \App\Models\CashbookEntry::findOrFail($id);
        $entry->delete();

        return redirect()->back()->with('success', 'Cashbook entry deleted successfully.');
    }
}
