<?php

namespace App\Http\Controllers;

use App\Models\ClientCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class ClientCategoryController extends Controller
{
    public function index()
    {
        $categories = ClientCategory::all();
        return view('modules.edit.client-categories', compact('categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'category_code' => 'required|string|max:255|unique:client_categories,category_code',
            'category_description' => 'required|string|max:255',
        ]);

        ClientCategory::create($request->all());

        Session::flash('success', 'Client category saved successfully.');
        return redirect()->route('modules.edit.client-categories');
    }

    public function edit($id)
    {
        $category = ClientCategory::findOrFail($id);
        $categories = ClientCategory::all();
        return view('modules.edit.client-categories', compact('category', 'categories'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'category_code' => 'required|string|max:255|unique:client_categories,category_code,' . $id,
            'category_description' => 'required|string|max:255',
        ]);

        $category = ClientCategory::findOrFail($id);
        $category->update($request->all());

        Session::flash('success', 'Client category updated successfully.');
        return redirect()->route('modules.edit.client-categories');
    }

    public function destroy($id)
    {
        $category = ClientCategory::findOrFail($id);
        $category->delete();

        Session::flash('success', 'Client category deleted successfully.');
        return redirect()->route('modules.edit.client-categories');
    }
}
