<?php

namespace App\Http\Controllers;

use App\Models\CourtArea;
use Illuminate\Http\Request;

class CourtAreaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $courtAreas = CourtArea::all();
        return view('modules.edit.court-areas', compact('courtAreas'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('modules.edit.court-area');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'area_code' => 'required|string|max:20|unique:court_areas,area_code',
            'area_name' => 'required|string|max:150',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|max:100',
            'specific_location' => 'nullable|string',
        ]);

        CourtArea::create($validated);

        return redirect()->route('modules.edit.court-areas')->with('success', 'Court Area created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $area_code)
    {
        $courtArea = CourtArea::where('area_code', $area_code)->firstOrFail();
        return view('modules.edit.court-area-show', compact('courtArea'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $area_code)
    {
        $courtArea = CourtArea::where('area_code', $area_code)->firstOrFail();
        return view('modules.edit.edit-court-area', compact('courtArea'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $area_code)
    {
        $courtArea = CourtArea::where('area_code', $area_code)->firstOrFail();

        $validated = $request->validate([
            'area_code' => 'required|string|max:20|unique:court_areas,area_code,' . $area_code . ',area_code',
            'area_name' => 'required|string|max:150',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|max:100',
            'specific_location' => 'nullable|string',
        ]);

        $courtArea->update($validated);

        return redirect()->route('modules.edit.court-areas')->with('success', 'Court Area updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $area_code)
    {
        $courtArea = CourtArea::where('area_code', $area_code)->firstOrFail();
        $courtArea->delete();

        return redirect()->route('modules.edit.court-areas')->with('success', 'Court Area deleted successfully.');
    }
}
