<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CourtController extends Controller
{
    public function courtDetails()
    {
        $courts = \App\Models\Court::all();
        return view('modules.processing.court-details', compact('courts'));
    }

    public function addCourt()
    {
        return view('modules.processing.add-court');
    }

    public function storeCourt(Request $request)
    {
        $validated = $request->validate([
            'court_name' => 'required|string|max:255',
            'court_type' => 'required|string|max:100',
            'jurisdiction' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'contact_person' => 'nullable|string|max:255',
            'notes' => 'nullable|string',
            'status' => 'required|in:active,inactive',
        ]);

        \App\Models\Court::create($validated);

        return redirect()->route('modules.processing.court.details')->with('success', 'Court added successfully.');
    }

    public function editCourt($id)
    {
        $court = \App\Models\Court::findOrFail($id);
        return view('modules.processing.edit-court', compact('court'));
    }

    public function updateCourt(Request $request, $id)
    {
        $court = \App\Models\Court::findOrFail($id);

        $validated = $request->validate([
            'court_name' => 'required|string|max:255',
            'court_type' => 'required|string|max:100',
            'jurisdiction' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'contact_person' => 'nullable|string|max:255',
            'notes' => 'nullable|string',
            'status' => 'required|in:active,inactive',
        ]);

        $court->update($validated);

        return redirect()->route('modules.processing.court.details')->with('success', 'Court updated successfully.');
    }

    public function destroyCourt($id)
    {
        $court = \App\Models\Court::findOrFail($id);
        $court->delete();

        return redirect()->route('modules.processing.court.details')->with('success', 'Court deleted successfully.');
    }

    public function showCourt($id)
    {
        $court = \App\Models\Court::findOrFail($id);
        return view('modules.processing.court-show', compact('court'));
    }
}
