<?php

namespace App\Http\Controllers;

use App\Models\CourtType;
use Illuminate\Http\Request;

class CourtTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $courtTypes = CourtType::all();
        return view('modules.edit.court-types', compact('courtTypes'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('modules.edit.court-type');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'type_name' => 'required|string|max:255|unique:court_types,type_name',
            'description' => 'nullable|string',
        ]);

        CourtType::create($validated);

        return redirect()->route('modules.edit.court-types')->with('success', 'Court Type created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $type_name)
    {
        $courtType = CourtType::where('type_name', $type_name)->firstOrFail();
        return view('modules.edit.court-type-show', compact('courtType'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $type_name)
    {
        $courtType = CourtType::where('type_name', $type_name)->firstOrFail();
        return view('modules.edit.edit-court-type', compact('courtType'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $type_name)
    {
        $courtType = CourtType::where('type_name', $type_name)->firstOrFail();

        $validated = $request->validate([
            'type_name' => 'required|string|max:255|unique:court_types,type_name,' . $courtType->type_name . ',type_name',
            'description' => 'nullable|string',
        ]);

        $courtType->update($validated);

        return redirect()->route('modules.edit.court-types')->with('success', 'Court Type updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $type_name)
    {
        $courtType = CourtType::where('type_name', $type_name)->firstOrFail();
        $courtType->delete();

        return redirect()->route('modules.edit.court-types')->with('success', 'Court Type deleted successfully.');
    }
}
