<?php

namespace App\Http\Controllers;

use App\Models\Department;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class DepartmentController extends Controller
{
    public function index()
    {
        $records = Department::all();
        return view('modules.edit.departments', compact('records'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'department_code' => 'required|string|max:255',
            'department_name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        Department::create([
            'department_code' => $request->department_code,
            'department_name' => $request->department_name,
            'description' => $request->description,
        ]);

        Session::flash('success', 'Department created successfully.');
        return redirect()->route('departments.index');
    }

    public function edit(Request $request)
    {
        $request->validate([
            'department_id' => 'required|integer',
            'department_code' => 'required|string|max:255',
            'department_name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $department = Department::findOrFail($request->department_id);
        $department->update([
            'department_code' => $request->department_code,
            'department_name' => $request->department_name,
            'description' => $request->description,
        ]);

        Session::flash('success', 'Department updated successfully.');
        return redirect()->route('departments.index');
    }

    public function destroy($id)
    {
        $department = Department::findOrFail($id);
        $department->delete();

        Session::flash('success', 'Department deleted successfully.');
        return redirect()->route('departments.index');
    }
}
