<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ClientInvoice;
use App\Models\ClientReceiptLine;
use App\Models\Client;

class FeeCollectionController extends Controller
{
    public function index(Request $request)
    {
        // Fetch clients for filter
        $clients = Client::all();

        // Fetch invoices with related data
        $invoices = ClientInvoice::with(['client', 'receiptLines'])
            ->where('status', '!=', 'draft')
            ->orderBy('invoice_date', 'desc')
            ->get();

        // Calculate metrics
        $totalCollected = $invoices->sum(function ($invoice) {
            return $invoice->receiptLines->sum('amount');
        });

        $totalInvoices = $invoices->count();

        $metrics = [
            'totalCollected' => $totalCollected,
            'totalInvoices' => $totalInvoices,
        ];

        // Apply filters if provided
        $clientId = $request->get('client_id');
        $dateFrom = $request->get('date_from');
        $dateTo = $request->get('date_to');

        if ($clientId) {
            $invoices = $invoices->where('client_id', $clientId);
        }

        if ($dateFrom) {
            $invoices = $invoices->where('invoice_date', '>=', $dateFrom);
        }

        if ($dateTo) {
            $invoices = $invoices->where('invoice_date', '<=', $dateTo);
        }

        return view('modules.reports.fee-collection', compact('invoices', 'metrics', 'clients'));
    }
}
