<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HelpController extends Controller
{
    public function index()
    {
        $helpTopics = [
            [
                'title' => 'Getting Started',
                'description' => 'Learn the basics of using the Prolex Law Firm System',
                'icon' => 'fas fa-rocket',
                'articles' => [
                    ['title' => 'Dashboard Overview', 'content' => 'The dashboard provides a quick overview of your cases, tasks, and important notifications.'],
                    ['title' => 'Navigation Guide', 'content' => 'Use the sidebar to navigate between different modules and features.'],
                    ['title' => 'User Profile Setup', 'content' => 'Complete your profile to personalize your experience and access all features.']
                ]
            ],
            [
                'title' => 'Case Management',
                'description' => 'Manage your legal cases efficiently',
                'icon' => 'fas fa-gavel',
                'articles' => [
                    ['title' => 'Creating New Cases', 'content' => 'Learn how to create and configure new legal cases with all necessary details.'],
                    ['title' => 'Case Status Tracking', 'content' => 'Monitor case progress and update statuses as cases move through different stages.'],
                    ['title' => 'Document Management', 'content' => 'Upload, organize, and share case-related documents securely.']
                ]
            ],
            [
                'title' => 'Client Management',
                'description' => 'Handle client relationships and communications',
                'icon' => 'fas fa-users',
                'articles' => [
                    ['title' => 'Adding New Clients', 'content' => 'Create client profiles with contact information and case history.'],
                    ['title' => 'Client Communications', 'content' => 'Track all interactions and communications with clients.'],
                    ['title' => 'Client Statements', 'content' => 'Generate and send financial statements to clients.']
                ]
            ],
            [
                'title' => 'Financial Management',
                'description' => 'Handle billing, invoicing, and financial reporting',
                'icon' => 'fas fa-calculator',
                'articles' => [
                    ['title' => 'Creating Invoices', 'content' => 'Generate professional invoices for client services.'],
                    ['title' => 'Fee Collection', 'content' => 'Track payments and manage outstanding fees.'],
                    ['title' => 'Financial Reports', 'content' => 'Generate comprehensive financial reports and statements.']
                ]
            ],
            [
                'title' => 'Task Management',
                'description' => 'Organize and track your daily tasks and deadlines',
                'icon' => 'fas fa-tasks',
                'articles' => [
                    ['title' => 'Creating Tasks', 'content' => 'Add new tasks with due dates and assign to team members.'],
                    ['title' => 'Task Prioritization', 'content' => 'Set priorities and organize tasks by importance and urgency.'],
                    ['title' => 'Calendar Integration', 'content' => 'Sync tasks with calendar for better time management.']
                ]
            ],
            [
                'title' => 'Reports & Analytics',
                'description' => 'Generate insights and track performance',
                'icon' => 'fas fa-chart-bar',
                'articles' => [
                    ['title' => 'Case Reports', 'content' => 'Analyze case outcomes and performance metrics.'],
                    ['title' => 'Financial Analytics', 'content' => 'Track revenue, expenses, and profitability trends.'],
                    ['title' => 'Client Analytics', 'content' => 'Understand client patterns and satisfaction metrics.']
                ]
            ]
        ];

        $faqs = [
            [
                'question' => 'How do I reset my password?',
                'answer' => 'Click on your profile dropdown in the top-right corner and select "Settings". From there, you can change your password or use the "Forgot Password" link on the login page.'
            ],
            [
                'question' => 'How do I create a new case?',
                'answer' => 'Navigate to the "Edit Menu" from the sidebar, then select "Cases". Click "Add Case" and fill in all required information including client details, case type, and description.'
            ],
            [
                'question' => 'How do I generate an invoice?',
                'answer' => 'Go to "Processing Center" > "Client Invoice". Select a client, add line items with descriptions and amounts, then process the invoice. You can also generate PDFs for client delivery.'
            ],
            [
                'question' => 'How do I add a new client?',
                'answer' => 'From the "Edit Menu", select "Clients". Click "Add Clients" and enter all client information including contact details, address, and any relevant case history.'
            ],
            [
                'question' => 'How do I track case deadlines?',
                'answer' => 'Use the "Diary" feature in the Processing Center to create tasks with due dates. You can also view upcoming deadlines in the dashboard and set up notifications.'
            ],
            [
                'question' => 'How do I generate reports?',
                'answer' => 'Navigate to "Reports" from the sidebar. Choose from various report types including financial statements, case status reports, and client statements. Most reports can be exported to PDF.'
            ]
        ];

        return view('help.index', compact('helpTopics', 'faqs'));
    }
}
