<?php

namespace App\Http\Controllers;

use App\Models\Judgement;
use Illuminate\Http\Request;

class JudgementController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $judgements = Judgement::all();
        return view('modules.edit.judgements', compact('judgements'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('modules.edit.judgement');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:255|unique:judgements,judgement_code',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        Judgement::create([
            'judgement_code' => $validated['code'],
            'title' => $validated['title'],
            'description' => $validated['description'] ?? null,
        ]);

        return redirect()->route('modules.edit.judgements')
            ->with('success', 'Judgement created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $judgement_code)
    {
        $judgement = Judgement::findOrFail($judgement_code);
        return view('modules.edit.judgement-show', compact('judgement'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $judgement_code)
    {
        $judgement = Judgement::findOrFail($judgement_code);
        return view('modules.edit.edit-judgement', compact('judgement'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $judgement_code)
    {
        $judgement = Judgement::findOrFail($judgement_code);

        $validated = $request->validate([
            'judgement_code' => 'required|string|max:255|unique:judgements,judgement_code,' . $judgement_code . ',judgement_code',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $judgement->update([
            'judgement_code' => $validated['judgement_code'],
            'title' => $validated['title'],
            'description' => $validated['description'] ?? null,
        ]);

        return redirect()->route('modules.edit.judgements')
            ->with('success', 'Judgement updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $judgement_code)
    {
        $judgement = Judgement::findOrFail($judgement_code);
        $judgement->delete();

        return redirect()->route('modules.edit.judgements')
            ->with('success', 'Judgement deleted successfully.');
    }
}
