<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Lawyer;
use App\Models\LegalCase;

class LawyerStatementController extends Controller
{
    public function index(Request $request)
    {
        // Fetch all lawyers
        $lawyers = Lawyer::all();

        // Select lawyer by id or default to first
        $selectedLawyerId = $request->input('lawyer_id', $lawyers->first()->id ?? null);

        $selectedLawyer = $selectedLawyerId ? Lawyer::find($selectedLawyerId) : null;

        // Fetch cases for the selected lawyer
        $cases = $selectedLawyer ? LegalCase::where('lawyer_id', $selectedLawyer->id)->get() : collect();

        // Calculate metrics
        $totalFeesGenerated = 0; // Placeholder, calculate based on business logic
        $activeCases = $cases->where('status', 'active')->count();
        $completedCases = $cases->where('status', 'completed')->count();
        $billableHours = 0; // Placeholder, calculate if data available
        $hourlyRate = 0; // Placeholder, from lawyer or elsewhere
        $clientCount = 0; // Placeholder, calculate distinct clients
        $successRate = 0; // Placeholder, calculate success rate

        // Pass data to view
        return view('modules.reports.lawyer-statement', [
            'lawyers' => $lawyers,
            'selectedLawyer' => $selectedLawyer,
            'cases' => $cases,
            'metrics' => [
                'totalFeesGenerated' => $totalFeesGenerated,
                'activeCases' => $activeCases,
                'completedCases' => $completedCases,
                'billableHours' => $billableHours,
                'hourlyRate' => $hourlyRate,
                'clientCount' => $clientCount,
                'successRate' => $successRate,
            ],
        ]);
    }

    public function generate(Request $request)
    {
        // Fetch all lawyers
        $lawyers = Lawyer::all();

        // Get form data
        $lawyerId = $request->input('customer_account');
        $dateFrom = $request->input('date_from');
        $dateTo = $request->input('date_to');
        $currency = $request->input('currency');

        // Select lawyer
        $selectedLawyer = null;
        if ($lawyerId && $lawyerId !== 'all') {
            $selectedLawyer = Lawyer::find($lawyerId);
        }

        // Fetch cases for the selected lawyer, filtered by date range
        $casesQuery = LegalCase::query();
        if ($selectedLawyer) {
            $casesQuery->where('lawyer_id', $selectedLawyer->id);
        }
        if ($dateFrom && $dateTo) {
            $casesQuery->whereBetween('created_at', [$dateFrom, $dateTo]);
        }
        $cases = $casesQuery->get();

        // Calculate metrics (placeholders for now)
        $totalFeesGenerated = 0; // Placeholder, calculate based on business logic
        $activeCases = $cases->where('status', 'active')->count();
        $completedCases = $cases->where('status', 'completed')->count();
        $billableHours = 0; // Placeholder, calculate if data available
        $hourlyRate = $selectedLawyer ? $selectedLawyer->hourly_rate ?? 0 : 0; // Assuming lawyer has hourly_rate
        $clientCount = $cases->pluck('client_name')->unique()->count();
        $successRate = $completedCases > 0 ? ($completedCases / $cases->count()) * 100 : 0;

        // Pass data to view
        return view('modules.reports.lawyer-statement', [
            'lawyers' => $lawyers,
            'selectedLawyer' => $selectedLawyer,
            'cases' => $cases,
            'metrics' => [
                'totalFeesGenerated' => $totalFeesGenerated,
                'activeCases' => $activeCases,
                'completedCases' => $completedCases,
                'billableHours' => $billableHours,
                'hourlyRate' => $hourlyRate,
                'clientCount' => $clientCount,
                'successRate' => $successRate,
            ],
        ]);
    }
}
