<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PasscodeController extends Controller
{
    public function show()
    {
        return view('chat.passcode');
    }

    public function verify(Request $request)
    {
        $request->validate([
            'passcode' => 'required|string|size:6',
        ]);

        if ($request->passcode === '000000') {
            return redirect()->route('chat.loading');
        }

        return back()->withErrors(['passcode' => 'Invalid passcode. Please try again.']);
    }
}
