<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\GeminiService;
use Illuminate\Support\Facades\Log;

class ProlyController extends Controller
{
    protected $ai;

    public function __construct(GeminiService $ai)
    {
        $this->ai = $ai;
    }

    public function index()
    {
        return view('proly.index');
    }

    public function chat(Request $request)
    {
        $request->validate([
            'message' => 'required|string|max:1000'
        ]);

        $message = $request->input('message');

        return response()->json([
            'success' => true,
            'response' => 'Bot completion has reached 60%, await for further updates to reasoning capacity',
            'timestamp' => now()->toISOString(),
            'model' => 'placeholder',
            'tokens' => 0
        ]);
    }

    /**
     * Optional: Method to test the API connection
     */
    public function testConnection()
    {
        try {
            $result = $this->ai->generateText("Say 'Hello, I am Proly, your legal assistant!' in a professional manner.");

            return response()->json([
                'success' => true,
                'message' => 'API connection successful',
                'response' => $result['text'] ?? 'No response',
                'model' => $result['model'] ?? 'unknown'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'API connection failed',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
