<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SupplierController extends Controller
{
    public function suppliers()
    {
        $suppliers = \App\Models\Supplier::all();
        return view('modules.processing.suppliers', compact('suppliers'));
    }

    public function addSupplier()
    {
        return view('modules.processing.add-supplier');
    }

    public function storeSupplier(Request $request)
    {
        $validated = $request->validate([
            'supplier_code' => 'required|string|max:255',
            'supplier_name' => 'required|string|max:255',
            'full_name' => 'nullable|string|max:255',
            'contact_person' => 'nullable|string|max:255',
            'contact_1' => 'nullable|string|max:255',
            'contact_2' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'category_id' => 'nullable|integer',
            'age_analysis_id' => 'nullable|integer',
            'area_id' => 'nullable|integer',
        ]);

        \App\Models\Supplier::create($validated);

        return redirect()->route('modules.processing.suppliers')->with('success', 'Supplier added successfully.');
    }

    public function editSupplier($id)
    {
        $supplier = \App\Models\Supplier::findOrFail($id);
        return view('modules.processing.edit-supplier', compact('supplier'));
    }

    public function updateSupplier(Request $request, $id)
    {
        $supplier = \App\Models\Supplier::findOrFail($id);

        $validated = $request->validate([
            'supplier_code' => 'required|string|max:255',
            'supplier_name' => 'required|string|max:255',
            'full_name' => 'nullable|string|max:255',
            'contact_person' => 'nullable|string|max:255',
            'contact_1' => 'nullable|string|max:255',
            'contact_2' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'category_id' => 'nullable|integer',
            'age_analysis_id' => 'nullable|integer',
            'area_id' => 'nullable|integer',
        ]);

        $supplier->update($validated);

        return redirect()->route('modules.processing.suppliers')->with('success', 'Supplier updated successfully.');
    }

    public function destroySupplier($id)
    {
        $supplier = \App\Models\Supplier::findOrFail($id);
        $supplier->delete();

        return redirect()->route('modules.processing.suppliers')->with('success', 'Supplier deleted successfully.');
    }

    public function showSupplier($id)
    {
        $supplier = \App\Models\Supplier::findOrFail($id);
        return view('modules.processing.supplier-show', compact('supplier'));
    }
}
