<?php

namespace App\Http\Controllers;

use App\Models\Tariff;
use Illuminate\Http\Request;

class TariffController extends Controller
{
    public function index()
    {
        $tariffs = Tariff::all();
        return view('modules.edit.tariff-list', compact('tariffs'));
    }

    public function create()
    {
        $lawyers = \App\Models\Lawyer::all();
        $lawyerTiers = \App\Models\LawyerTier::all();
        $lawyerGroups = \App\Models\LawyerGroup::all();
        $lawyerTypes = \App\Models\LawyerType::all();
        $currencies = \App\Models\Currency::all();
        return view('modules.edit.tariff', compact('lawyers', 'lawyerTiers', 'lawyerGroups', 'lawyerTypes', 'currencies'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'lawyer_id' => 'nullable|string',
            'lawyer_tier_id' => 'nullable|integer',
            'lawyer_group_id' => 'nullable|integer',
            'lawyer_type_id' => 'nullable|integer',
            'service_name' => 'required|string|max:100',
            'billing_method' => 'required|in:HOURLY,FIXED_FEE,PER_APPEARANCE,PER_STAGE,RETAINER_PLUS,CONTINGENCY,SUBSCRIPTION',
            'rate_type' => 'required|in:PER_HOUR,PER_CASE,PER_DOCUMENT,PER_APPEARANCE,PER_CONSULTATION,PER_MONTH,PERCENTAGE',
            'rate_amount' => 'required|numeric|min:0',
            'currency' => 'required|string|max:10',
            'effective_from' => 'required|date',
            'minimum_fee' => 'nullable|numeric|min:0',
            'maximum_fee' => 'nullable|numeric|min:0',
            'billing_increment' => 'nullable|integer|in:15,30,60',
            'retainer_required' => 'boolean',
            'retainer_amount' => 'nullable|numeric|min:0',
            'court_level' => 'nullable|in:MAGISTRATES,HIGH_COURT,SUPREME_COURT,CONSTITUTIONAL_COURT',
            'complexity_level' => 'nullable|in:LOW,MEDIUM,HIGH',
            'tax_inclusive' => 'boolean',
            'vat_rate' => 'nullable|numeric|min:0|max:100',
            'effective_to' => 'nullable|date|after:effective_from',
            'description' => 'nullable|string',
        ]);

        Tariff::create($validated);

        return redirect()->route('tariffs.index')->with('success', 'Tariff created successfully.');
    }

    public function show($id)
    {
        $tariff = Tariff::findOrFail($id);
        return view('modules.edit.tariff-show', compact('tariff'));
    }

    public function edit($id)
    {
        $tariff = Tariff::findOrFail($id);
        $lawyers = \App\Models\Lawyer::all();
        $lawyerTiers = \App\Models\LawyerTier::all();
        $lawyerGroups = \App\Models\LawyerGroup::all();
        $lawyerTypes = \App\Models\LawyerType::all();
        $currencies = \App\Models\Currency::all();
        return view('modules.edit.edit-tariff', compact('tariff', 'lawyers', 'lawyerTiers', 'lawyerGroups', 'lawyerTypes', 'currencies'));
    }

    public function update(Request $request, $id)
    {
        $tariff = Tariff::findOrFail($id);

        $validated = $request->validate([
            'lawyer_id' => 'nullable|string',
            'lawyer_tier_id' => 'nullable|integer',
            'lawyer_group_id' => 'nullable|integer',
            'lawyer_type_id' => 'nullable|integer',
            'service_name' => 'required|string|max:100',
            'billing_method' => 'required|in:HOURLY,FIXED_FEE,PER_APPEARANCE,PER_STAGE,RETAINER_PLUS,CONTINGENCY,SUBSCRIPTION',
            'rate_type' => 'required|in:PER_HOUR,PER_CASE,PER_DOCUMENT,PER_APPEARANCE,PER_CONSULTATION,PER_MONTH,PERCENTAGE',
            'rate_amount' => 'required|numeric|min:0',
            'currency' => 'required|string|max:10',
            'effective_from' => 'required|date',
            'minimum_fee' => 'nullable|numeric|min:0',
            'maximum_fee' => 'nullable|numeric|min:0',
            'billing_increment' => 'nullable|integer|in:15,30,60',
            'retainer_required' => 'boolean',
            'retainer_amount' => 'nullable|numeric|min:0',
            'court_level' => 'nullable|in:MAGISTRATES,HIGH_COURT,SUPREME_COURT,CONSTITUTIONAL_COURT',
            'complexity_level' => 'nullable|in:LOW,MEDIUM,HIGH',
            'tax_inclusive' => 'boolean',
            'vat_rate' => 'nullable|numeric|min:0|max:100',
            'effective_to' => 'nullable|date|after:effective_from',
            'description' => 'nullable|string',
        ]);

        $tariff->update($validated);

        return redirect()->route('tariffs.index')->with('success', 'Tariff updated successfully.');
    }

    public function destroy($id)
    {
        $tariff = Tariff::findOrFail($id);
        $tariff->delete();

        return redirect()->route('tariffs.index')->with('success', 'Tariff deleted successfully.');
    }
}
