<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class TaxController extends Controller
{
    public function index()
    {
        $taxes = \App\Models\Tax::all();
        return view('modules.edit.tax-list', compact('taxes'));
    }

    public function create()
    {
        return view('modules.edit.add-tax');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'tax_name' => 'required|string|max:100',
            'tax_type' => 'required|in:Corporate Income Tax,PAYE / Payroll Tax,VAT,Withholding Tax,Capital Gains Tax,Presumptive/Turnover Tax,Local Business Taxes',
            'tax_rate' => 'required|numeric|min:0|max:100',
            'tax_description' => 'nullable|string|max:255',
            'is_active' => 'boolean',
        ]);

        \App\Models\Tax::create($validated);

        return redirect()->route('taxes.index')->with('success', 'Tax added successfully.');
    }

    public function edit($tax_id)
    {
        $tax = \App\Models\Tax::findOrFail($tax_id);
        return view('modules.edit.edit-tax', compact('tax'));
    }

    public function update(Request $request, $tax_id)
    {
        $tax = \App\Models\Tax::findOrFail($tax_id);

        $validated = $request->validate([
            'tax_name' => 'required|string|max:100',
            'tax_type' => 'required|in:Corporate Income Tax,PAYE / Payroll Tax,VAT,Withholding Tax,Capital Gains Tax,Presumptive/Turnover Tax,Local Business Taxes',
            'tax_rate' => 'required|numeric|min:0|max:100',
            'tax_description' => 'nullable|string|max:255',
            'is_active' => 'boolean',
        ]);

        $tax->update($validated);

        return redirect()->route('taxes.index')->with('success', 'Tax updated successfully.');
    }

    public function destroy($tax_id)
    {
        $tax = \App\Models\Tax::findOrFail($tax_id);
        $tax->delete();

        return redirect()->route('taxes.index')->with('success', 'Tax deleted successfully.');
    }
}
