<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ClientInvoice;
use App\Models\Client;
use App\Models\Currency;

class TotalFeesController extends Controller
{
    public function index(Request $request)
    {
        // Fetch invoices with related data
        $invoices = ClientInvoice::with(['client', 'currency', 'receiptLines'])
            ->where('status', '!=', 'draft')
            ->orderBy('invoice_date', 'desc')
            ->get();

        // Calculate metrics
        $totalFees = $invoices->sum('total');
        $paidFees = $invoices->sum(function ($invoice) {
            return $invoice->receiptLines->sum('amount');
        });
        $outstandingFees = $totalFees - $paidFees;
        $totalInvoices = $invoices->count();

        $metrics = [
            'totalFees' => $totalFees,
            'paidFees' => $paidFees,
            'outstandingFees' => $outstandingFees,
            'totalInvoices' => $totalInvoices,
        ];

        // Apply filters if provided
        $clientId = $request->get('client_id');
        $status = $request->get('status');
        $dateFrom = $request->get('date_from');
        $dateTo = $request->get('date_to');

        if ($clientId) {
            $invoices = $invoices->where('client_id', $clientId);
        }

        if ($status) {
            $invoices = $invoices->where('status', $status);
        }

        if ($dateFrom) {
            $invoices = $invoices->where('invoice_date', '>=', $dateFrom);
        }

        if ($dateTo) {
            $invoices = $invoices->where('invoice_date', '<=', $dateTo);
        }

        return view('modules.reports.total-fees', compact('invoices', 'metrics'));
    }
}
