<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Session;
use Illuminate\Support\Facades\Log;

class ActivityTrackingMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Update last activity if we have a valid session
        if ($request->has('current_session')) {
            $session = $request->current_session;
            $session->update(['last_activity' => now()]);

            // Log activity for audit purposes
            Log::info('User activity tracked', [
                'user_id' => $session->user_id,
                'session_id' => $session->session_id,
                'url' => $request->fullUrl(),
                'method' => $request->method(),
                'ip' => $request->ip()
            ]);
        }

        return $response;
    }
}
