<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Models\UserSession;
use Symfony\Component\HttpFoundation\Response;

class SessionValidationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();
            $sessionId = session()->getId();

            // Check if session exists in user_sessions table
            $userSession = UserSession::where('user_id', $user->id)
                ->where('session_id', $sessionId)
                ->where('status', 'active')
                ->first();

            if (!$userSession) {
                Log::warning('Invalid session detected in user_sessions table', [
                    'user_id' => $user->id,
                    'session_id' => $sessionId,
                    'ip' => $request->ip(),
                    'user_agent' => $request->userAgent()
                ]);

                // Custom sessions are observational only - do not invalidate Laravel auth
                // Laravel auth remains the source of truth
            } else {
                // Update last activity
                $userSession->update(['last_seen_at' => now()]);
            }
        }

        return $next($request);
    }
}
