<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 */
class Assignment extends Model
{
    protected $fillable = [
        'assignment_title',
        'lawyer_id',
        'task_type',
        'priority',
        'client_id',
        'case_id',
        'case_type_id',
        'case_category_id',
        'due_date',
        'due_time',
        'estimated_hours',
        'status',
        'description',
        'instructions',
        'documents_required',
        'court_date',
        'court_time',
        'court_location',
        'opposing_counsel',
        'judge_id',
        'client_contact_info',
        'billing_notes',
        'due_datetime',
        'court_datetime',
        'created_by',
        'assigned_date',
        'progress_percentage',
        'is_billable',
    ];

    protected $casts = [
        'due_datetime' => 'datetime',
        'court_datetime' => 'datetime',
        'assigned_date' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'is_billable' => 'boolean',
        'progress_percentage' => 'decimal:2',
        'estimated_hours' => 'decimal:2',
    ];

    public function lawyer(): BelongsTo
    {
        return $this->belongsTo(Lawyer::class);
    }

    public function client(): BelongsTo
    {
        return $this->belongsTo(Client::class);
    }

    public function legalCase(): BelongsTo
    {
        return $this->belongsTo(LegalCase::class, 'case_id');
    }

    public function caseType(): BelongsTo
    {
        return $this->belongsTo(CaseType::class);
    }

    public function caseCategory(): BelongsTo
    {
        return $this->belongsTo(CaseCategory::class);
    }

    public function caseStatus(): BelongsTo
    {
        return $this->belongsTo(CaseStatus::class);
    }

    public function judge(): BelongsTo
    {
        return $this->belongsTo(Judge::class, 'judge_id', 'judge_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function histories()
    {
        return $this->hasMany(AssignmentHistory::class, 'assignment_id', 'id');
    }
}
