<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CancelledReason extends Model
{
    protected $primaryKey = 'reason_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'reason_code',
        'reason_name',
        'description',
        'priority',
        'status',
        'requires_approval',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'requires_approval' => 'boolean',
    ];

    /**
     * Get the legal cases for this cancelled reason.
     */
    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'cancelled_reason_code', 'reason_code');
    }

    /**
     * Scope to get only active cancelled reasons.
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'ACTIVE');
    }

    /**
     * Scope to filter by priority.
     */
    public function scopeByPriority($query, $priority)
    {
        return $query->where('priority', $priority);
    }
}
