<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CaseCategory extends Model
{
    protected $primaryKey = 'category_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'category_code',
        'category_description',
        'created_at',
        'updated_at',
    ];

    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'category_code', 'category_code');
    }
}
