<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CaseOutcome extends Model
{
    protected $fillable = [
        'code',
        'name',
        'description',
        'created_at',
        'updated_at',
    ];

    /**
     * Get the legal cases for this outcome.
     */
    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'case_outcome', 'id');
    }

    /**
     * Scope to get only active case outcomes (assuming we add a status field later if needed).
     */
    public function scopeActive($query)
    {
        // For now, no status field, so return all
        return $query;
    }
}
