<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CaseParty extends Model
{
    protected $fillable = [
        'case_id',
        'party_name',
        'party_type',
        'contact_info',
        'email',
        'phone',
        'address',
        'role_id',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function legalCase()
    {
        return $this->belongsTo(LegalCase::class, 'case_id', 'case_id');
    }

    public function caseRole()
    {
        return $this->belongsTo(CaseRole::class, 'role_id', 'role_id');
    }
}
