<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CasePriority extends Model
{
    use HasFactory;

    protected $table = 'case_priorities';

    protected $primaryKey = 'priority_id';

    protected $keyType = 'int';

    public $incrementing = true;

    protected $fillable = [
        'priority_name',
        'description',
        'severity_rank',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'severity_rank' => 'integer',
    ];

    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'case_priority_id', 'priority_id');
    }
}
