<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class CaseReason extends Model
{
    protected $primaryKey = 'reason_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'reason_code',
        'reason_name',
        'reason_description',
        'status',
        'created_by',
        'updated_by',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    /**
     * Get the legal cases for this reason.
     */
    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'cancelled_reason_code', 'reason_code');
    }

    /**
     * Get the user who created this case reason.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the user who last updated this case reason.
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    /**
     * Scope to get only active case reasons.
     */
    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    /**
     * Scope to filter by priority.
     */
    public function scopeByPriority($query, $priority)
    {
        return $query->where('priority', $priority);
    }
}
