<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CaseStatus extends Model
{
    protected $primaryKey = 'status_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'status_code',
        'status_name',
        'status_description',
        'color_code',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the legal cases for this status.
     */
    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'status_code', 'status_code');
    }

    /**
     * Scope to get only active case statuses.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to order by sort order.
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('status_name');
    }
}
