<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CaseType extends Model
{
    use HasFactory;

    protected $primaryKey = 'type_id';

    protected $keyType = 'int';

    public $incrementing = true;

    protected $fillable = [
        'type_name',
        'type_description',
        'created_at',
        'updated_at',
    ];

    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'case_type_id', 'type_id');
    }
}
