<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cashbook extends Model
{
    use HasFactory;

    protected $table = 'cashbooks';

    protected $fillable = [
        'code',
        'name',
        'cashbook_type',
        'is_trust',
        'currency_id',
        'opening_balance',
        'opening_balance_date',
        'bank_name',
        'branch_name',
        'account_number',
        'swift_code',
        'is_reconcilable',
        'is_active'
    ];

    protected $casts = [
        'is_trust' => 'boolean',
        'is_reconcilable' => 'boolean',
        'is_active' => 'boolean',
        'opening_balance' => 'decimal:2',
        'opening_balance_date' => 'date'
    ];

    // Relationships
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function cashbookEntries()
    {
        return $this->hasMany(CashbookEntry::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeTrust($query)
    {
        return $query->where('is_trust', true);
    }

    public function scopeReconcilable($query)
    {
        return $query->where('is_reconcilable', true);
    }
}
