<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientInvoice extends Model
{
    protected $table = 'client_invoices';

    protected $fillable = [
        'client_id',
        'invoice_number',
        'invoice_date',
        'case_reference',
        'description',
        'responsible_lawyer',
        'narration',
        'gl_account',
        'tax_id',
        'discount',
        'price',
        'quantity',
        'currency_id',
        'disbursements',
        'tax_rate',
        'tax_amount',
        'total',
        'status',
        'user_id',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'price' => 'decimal:2',
        'quantity' => 'decimal:2',
        'discount' => 'decimal:2',
        'tax_rate' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total' => 'decimal:2',
        'disbursements' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class, 'tax_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function lines()
    {
        return $this->hasMany(ClientInvoiceLine::class, 'invoice_id');
    }

    public function getDocumentDateAttribute()
    {
        return $this->invoice_date;
    }

    public function getDocumentNumberAttribute()
    {
        return $this->invoice_number;
    }
}
