<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientJournal extends Model
{
    protected $table = 'prolex.client_journals';

    protected $fillable = [
        'date',
        'client_code',
        'client_name',
        'narration',
        'dr',
        'cr',
        'status',
        'client_id',
        'transaction_code',
    ];

    public function clientAccount()
    {
        return $this->belongsTo(ClientAccount::class, 'client_id');
    }
}
