<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CourtFiling extends Model
{
    protected $table = 'court_filings';
    protected $primaryKey = 'filing_id';

    protected $fillable = [
        'case_id',
        'filing_type_id',
        'filing_status_id',
        'filing_code',
        'filing_title',
        'filing_description',
        'court_area_id',
        'judge_id',
        'filing_date',
        'due_date',
        'court_acknowledgment',
        'document_path',
        'version',
        'next_action',
        'internal_notes',
        'external_notes',
        'created_by',
        'updated_by',
    ];

    protected $dates = [
        'filing_date',
        'due_date',
        'court_acknowledgment',
        'created_at',
        'updated_at',
    ];

    // Relationships
    public function legalCase()
    {
        return $this->belongsTo(LegalCase::class, 'case_id', 'id');
    }

    public function filingType()
    {
        return $this->belongsTo(CourtFilingType::class, 'filing_type_id', 'filing_type_id');
    }

    public function filingStatus()
    {
        return $this->belongsTo(CourtFilingStatus::class, 'filing_status_id', 'filing_status_id');
    }

    public function courtArea()
    {
        return $this->belongsTo(CourtArea::class, 'court_area_id', 'area_code');
    }

    public function judge()
    {
        return $this->belongsTo(Judge::class, 'judge_id', 'judge_code');
    }

    public function lawyer()
    {
        return $this->belongsTo(Lawyer::class, 'responsible_lawyer_id', 'id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by', 'id');
    }
}
