<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CourtFilingStatus extends Model
{
    protected $table = 'court_filing_statuses';
    protected $primaryKey = 'filing_status_id';

    protected $fillable = [
        'status_code',
        'status_name',
        'description',
        'display_order',
        'is_final',
    ];

    protected $casts = [
        'is_final' => 'boolean',
    ];

    // Relationships
    public function courtFilings()
    {
        return $this->hasMany(CourtFiling::class, 'filing_status_id', 'filing_status_id');
    }
}
