<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CourtFilingType extends Model
{
    protected $table = 'court_filing_types';
    protected $primaryKey = 'filing_type_id';

    protected $fillable = [
        'type_code',
        'type_name',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function courtFilings()
    {
        return $this->hasMany(CourtFiling::class, 'filing_type_id', 'filing_type_id');
    }
}
