<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $primaryKey = 'currency_id';
    protected $fillable = ['symbol', 'currency_name', 'currency_code', 'country', 'is_active'];

    public function homeCurrencies()
    {
        return $this->hasMany(HomeCurrency::class, 'currency_id', 'currency_id');
    }

    public function rates()
    {
        return $this->hasMany(Rate::class);
    }
}
