<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GeneralJournal extends Model
{
    protected $fillable = [
        'account_id',
        'date',
        'narration',
        'tr_code',
        'currency_id',
        'amount',
        'status',
    ];

    public function account()
    {
        return $this->belongsTo(MainAccount::class, 'account_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }
}
