<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    use HasFactory;

    protected $table = 'user_groups';
    protected $primaryKey = 'user_group_id';
    public $timestamps = false;

    protected $fillable = [
        'group_name',
        'group_description',
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'group_id');
    }

    public function userGroups()
    {
        return $this->hasMany(UserGroup::class, 'group_id');
    }
}
