<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HomeCurrencyHistory extends Model
{
    protected $table = 'home_currency_history';
    protected $primaryKey = 'history_id';
    protected $fillable = ['currency_id', 'effective_date', 'deactivated_date', 'changed_by'];
    public $timestamps = false;

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id', 'currency_id');
    }

    public function changer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
