<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Judge extends Model
{
    use HasFactory;

    protected $primaryKey = 'judge_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'judge_code',
        'full_name',
        'court_area_code',
        'court_type_name',
        'contact',
        'email',
        'notes',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function courtArea()
    {
        return $this->belongsTo(CourtArea::class, 'court_area_code', 'area_code');
    }

    public function courtType()
    {
        return $this->belongsTo(CourtType::class, 'court_type_name', 'type_name');
    }
}
