<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Judgement extends Model
{
    use HasFactory;

    protected $primaryKey = 'judgement_code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'judgement_code',
        'title',
        'description',
        'created_at',
        'updated_at',
    ];

    public function legalCases()
    {
        return $this->hasMany(LegalCase::class, 'judgement_id', 'judgement_code');
    }
}
