<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lawyer extends Model
{
    protected $primaryKey = 'lawyer_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'lawyer_id',
        'first_name',
        'last_name',
        'email',
        'phone_primary',
        'phone_secondary',
        'lawyer_group',
        'certificate_number',
        'date_of_admission',
        'status',
        'lawyer_type',
        'lawyer_tier',
        'notes',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'date_of_admission' => 'date',
    ];

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function caseLawyers()
    {
        return $this->hasMany(CaseLawyer::class, 'lawyer_id', 'lawyer_id');
    }

    public function lawyerGroup()
    {
        return $this->belongsTo(LawyerGroup::class, 'lawyer_group', 'group_id');
    }
}
