<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LawyerRole extends Model
{
    protected $table = 'lawyer_roles';

    protected $primaryKey = 'lawyer_role_id';

    protected $fillable = [
        'code',
        'name',
        'description',
        'side',
        'is_primary',
        'requires_bar_status',
        'jurisdiction_scope',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_primary' => 'boolean',
        'requires_bar_status' => 'boolean',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    // Add any relationships if needed
    // For example, if lawyers can have roles:
    // public function lawyers()
    // {
    //     return $this->hasMany(Lawyer::class, 'role_id', 'lawyer_role_id');
    // }
}
