<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LawyerTier extends Model
{
    use HasFactory;

    protected $table = 'lawyer_tiers';
    protected $primaryKey = 'tier_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'tier_name',
        'description',
        'default_hourly_rate',
    ];

    protected $casts = [
        'default_hourly_rate' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
}
