<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LawyerType extends Model
{
    use HasFactory;

    protected $table = 'lawyer_types';
    protected $primaryKey = 'type_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'group_id',
        'lawyer_type_name',
        'status',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function lawyerGroup()
    {
        return $this->belongsTo(LawyerGroup::class, 'group_id', 'group_id');
    }
}
