<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LegalCase extends Model
{
    protected $table = 'cases';

    protected $fillable = [
        'case_id',
        'case_name',
        'client_id',
        'category_code',
        'type_id',
        'priority_id',
        'role_id',
        'date_of_incident',
        'court_appearance_date',
        'notes',
        'case_code',
        'type_name',
        'status_code',
        'cancelled_reason_code',
        'case_reason',
        'created_at',
        'updated_at',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id', 'id');
    }

    public function caseCategory()
    {
        return $this->belongsTo(CaseCategory::class, 'category_code', 'category_code');
    }

    public function caseType()
    {
        return $this->belongsTo(CaseType::class, 'type_name', 'type_name');
    }

    public function caseStatus()
    {
        return $this->belongsTo(CaseStatus::class, 'status_code', 'status_code');
    }

    public function cancelledReason()
    {
        return $this->belongsTo(CaseReason::class, 'cancelled_reason_code', 'reason_code');
    }

    public function caseOutcome()
    {
        return $this->belongsTo(CaseOutcome::class, 'case_outcome', 'id');
    }

    public function parties()
    {
        return $this->hasMany(CaseParty::class, 'case_id', 'case_id');
    }

    public function caseLawyers()
    {
        return $this->hasMany(CaseLawyer::class, 'case_id', 'id');
    }

    public function lawyer()
    {
        return $this->belongsTo(Lawyer::class, 'lawyer_id', 'lawyer_id');
    }
}
